"use server"
import { redirect } from "next/navigation";
import { getCurrentUserFromServer, getIsUserAuthenticatedFromServer, getIsUserAuthorizedFromServer } from "./session.amplify";
import { DEFAULT_UNAUTHENTICATED_REDIRECT_URL, DEFAULT_UNAUTHORIZED_REDIRECT_URL } from "@/config/site";
import { AppUserGroup } from "@/zod/amplify.schema";

/**
 * Redirects to the given url when no user session is currently stored
 * otherwise the current user is returned
 * 
 * @param url url to redirect to __*Default = '/login'*__
 * @returns current user or never
 */
export async function nextjsRedirectUserGuard(url = DEFAULT_UNAUTHENTICATED_REDIRECT_URL) {
  const isAuthenticated = await getIsUserAuthenticatedFromServer();
  if (!isAuthenticated) {
    redirect(url)
  }

  return getCurrentUserFromServer()
}

/**
 * Redirects to the given url when a user session is currently stored
 * otherwise return
 * 
 * @param url url to redirect to __*Default = '/'*__
 */
export async function nextjsRedirectUserAuthenticatedGuard(url = '/') {
  const isAuthenticated = await getIsUserAuthenticatedFromServer();
  if (!isAuthenticated) {
    return;
  }

  redirect(url)
}

/**
 * Redirects to the given url when no user session is currently stored
 * or that the current user has the proper group
 * otherwise return
 * 
 * @param group group to ensure user is a part of
 * @param url url to redirect to __*Default = '/'*__
 */
export async function nextjsRedirectUserAuthorizedGuard(group: AppUserGroup, url = DEFAULT_UNAUTHORIZED_REDIRECT_URL) {
  const isAuthorized = await getIsUserAuthorizedFromServer(group);
  if (!isAuthorized) {
    redirect(url)
  }

  return;
}
